<?php

/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
namespace Google\Site_Kit_Dependencies\Google\Service\TagManager;

class GalleryReference extends \Google\Site_Kit_Dependencies\Google\Model
{
    /**
     * @var string
     */
    public $host;
    /**
     * @var bool
     */
    public $isModified;
    /**
     * @var string
     */
    public $owner;
    /**
     * @var string
     */
    public $repository;
    /**
     * @var string
     */
    public $signature;
    /**
     * @var string
     */
    public $version;
    /**
     * @param string
     */
    public function setHost($host)
    {
        $this->host = $host;
    }
    /**
     * @return string
     */
    public function getHost()
    {
        return $this->host;
    }
    /**
     * @param bool
     */
    public function setIsModified($isModified)
    {
        $this->isModified = $isModified;
    }
    /**
     * @return bool
     */
    public function getIsModified()
    {
        return $this->isModified;
    }
    /**
     * @param string
     */
    public function setOwner($owner)
    {
        $this->owner = $owner;
    }
    /**
     * @return string
     */
    public function getOwner()
    {
        return $this->owner;
    }
    /**
     * @param string
     */
    public function setRepository($repository)
    {
        $this->repository = $repository;
    }
    /**
     * @return string
     */
    public function getRepository()
    {
        return $this->repository;
    }
    /**
     * @param string
     */
    public function setSignature($signature)
    {
        $this->signature = $signature;
    }
    /**
     * @return string
     */
    public function getSignature()
    {
        return $this->signature;
    }
    /**
     * @param string
     */
    public function setVersion($version)
    {
        $this->version = $version;
    }
    /**
     * @return string
     */
    public function getVersion()
    {
        return $this->version;
    }
}
// Adding a class alias for backwards compatibility with the previous class name.
\class_alias(\Google\Site_Kit_Dependencies\Google\Service\TagManager\GalleryReference::class, 'Google\\Site_Kit_Dependencies\\Google_Service_TagManager_GalleryReference');
